/*
 * Decompiled with CFR 0.152.
 */
package com.android.customer.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.domain.model.BaseResponse;
import com.android.core.domain.model.GenericResponse;
import com.android.core.domain.model.RequestData;
import com.android.customer.domain.use_case.SaveCustomerPic;
import com.android.files.data.repository.PictureInfoRepo;
import com.dto.LoginDto;
import com.security.SecurityConstants;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import com.utility.SoftwareInfo;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class CustomerPicRepo
extends AndroidRepository<Map<String, Object>> {
    private final ApplicationContext context;

    public CustomerPicRepo(DbConnection dbConnection, ApplicationContext context) {
        super(dbConnection);
        this.context = context;
    }

    public BaseResponse<Map<String, Object>> customQuery(RequestData request, Paging paging, LoginDto login) {
        String sql = this.makeSql(request, paging, login);
        PictureInfoRepo infoRepo = new PictureInfoRepo(this.dbConnection, login);
        return new BaseResponse.Builder().data(infoRepo.generateJson(sql)).totalCount(this.getTotalCount()).totalPages(this.getTotalPages()).build();
    }

    @Nullable
    protected Paging.PageSqlData queryWithDefaultPaging(@NotNull SettingLoader settingsLoader) {
        if (settingsLoader.sendPicturesDisabled()) {
            return null;
        }
        String select = " SELECT iai.id hloPicId, image_src + '_' + CAST(iai.id AS NVARCHAR) + '_' + c.C_CODE AS id, \n iai.picturePath filePath, iai.[type], \n (CASE WHEN DataLength(iai.[picture]) > 1 THEN DataLength(iai.[picture]) ELSE -1 END) AS fileSize \n FROM HLOPictures iai \n";
        SoftwareInfo softwareInfo = new SoftwareInfo(this.dbConnection.getJdbcTemplate(settingsLoader.getLogin()));
        String join = (!softwareInfo.isRestaurant() ? " LEFT JOIN CUSTOMER c ON iai.code = c.C_Code \n" : "") + (settingsLoader.userHasLimitedAccessToCustomers() ? " INNER JOIN(SELECT * FROM RMUserArtAccess \n WHERE UserId= " + settingsLoader.getLogin().getUserCodeInc() + " AND IsNull(DataTypeId, 0) = 1) RMUA ON RMUA.ArticleId = iai.code " : "");
        String where = " WHERE Code IS NOT NULL AND iai.[Type] = 2 ";
        return Paging.PageSqlData.builder().selectSqlStr(select).joinsStr(join).whereStr(where).alias("iai").keyField("hloPicId").build();
    }

    public BaseResponse<GenericResponse> postPicture(List<MultipartFile> fileList) {
        SaveCustomerPic saveCustomerPic = (SaveCustomerPic)this.context.getBean(SaveCustomerPic.class);
        BaseResponse.Builder response = new BaseResponse.Builder();
        for (MultipartFile file : fileList) {
            response.mergeResponse((BaseResponse)this.dbConnection.getTransactionTemplate(SecurityConstants.loadToken()).execute(status -> this.makeBaseGenericResponse(status, () -> saveCustomerPic.invoke(file))));
        }
        return response.build();
    }
}

